/** @file   menunotification.cpp
 * @brief   Implementation of MenuNotification - class.
 * @version $Revision: 1.3 $
 * @author  Tomi Lamminsaari
 */
 
#include "menunotification.h"
#include "GfxManager.h"
#include "soundsamples.h"
#include "eng2d.h"
#include "GfxId.h"
using namespace eng2d;
using std::string;


namespace WeWantWar {


/** Constructs the mainmenu-object
 */
MenuNotification::MenuNotification() :
  MenuPage(),
  m_gotoPage( MenuPage::MAINMENU )
{
}


MenuNotification::MenuNotification( const string& caption, const string& line1 ):
  MenuPage(),
  m_caption( caption ),
  m_line1( line1 ),
  m_gotoPage( MenuPage::MAINMENU )
{
}


MenuNotification::MenuNotification( const string& caption, const string& line1,
                                    const string& line2 ):
  MenuPage(),
  m_caption( caption ),
  m_line1( line1 ),
  m_line2( line2 ),
  m_gotoPage( MenuPage::MAINMENU )
{
}



/** Destructor
 */
MenuNotification::~MenuNotification()
{
}


int MenuNotification::update()
{
  int ret = MenuPage::NO_PAGE_CHANGE;

  if ( key[MenuPage::s_lastKey] ) {
    return ret;
  }
  MenuPage::s_lastKey = KEY_O;

  if ( key[KEY_ENTER] ) {
    MenuPage::s_lastKey = KEY_ENTER;
    ret = MenuPage::PAGE_CHANGE;

  } else if ( key[KEY_SPACE] ) {
    MenuPage:s_lastKey = KEY_SPACE;
    ret = MenuPage::PAGE_CHANGE;
  }

  if ( ret == MenuPage::PAGE_CHANGE ) {
    Sound::playSample(SMP_MENUSELECT, false);
  }
  return ret;
}


void MenuNotification::redraw()
{
  BITMAP* b = GfxManager::findBitmap( GfxId::KMenuSmallWindow );
  int hw = b->w / 2;
  int hh = b->h / 2;
  
  int x = 320 - ( b->w/2 );
  int y = 240 - ( b->h/2 );
  draw_sprite( Display::buffer, b, x,y );
  
  TPrinter out( Display::buffer );
  out.font( GfxManager::titleFont, "normal30" );
  out.align( TPrinter::ALIGN_CENTER );
  out.pos( 320, 170 );
  out.print( m_caption );
  
  out.font( GfxManager::titleFont, "menuitems_sel" );
  out.pos( 320, 280 );
  out.print( m_line1 );
  out.pos( 320,310 );
  out.print( m_line2 );
}

void MenuNotification::setCaption( const string& caption )
{
  m_caption = caption;
}


void MenuNotification::setLine1( const string& line1 )
{
  m_line1 = line1;
}


void MenuNotification::setLine2( const string& line2 )
{
  m_line2 = line2;
}


void MenuNotification::setGotoPage( MenuPage::PageID gotoPage )
{
  m_gotoPage = gotoPage;
}



MenuPage::PageID MenuNotification::getGotoPage() const
{
  return m_gotoPage;
}


} // end of namespace


